local assets =
{
	Asset("ANIM", "anim/balloons_empty.zip"),
	--Asset("SOUND", "sound/common.fsb"),
}
 
local prefabs =
{
	"balloon",
}    

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
    anim:SetBank("balloons_empty")
    anim:SetBuild("balloons_empty")
    anim:PlayAnimation("idle")
    MakeInventoryPhysics(inst)

    local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon( "balloons_empty.png" )
    
    
    inst:AddComponent("inventoryitem")
    -----------------------------------


    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("balloonmaker")
	
	
	
	
	
		local ownertag = "wes"
		local function undropppable(inst)
					--local found = false
				local owner1 = FindEntity(inst, 1, function(guy) return (guy:HasTag("player3") and guy:HasTag(ownertag) and not guy.components.health:IsDead())end)
				if owner1 then
					local action = ACTIONS.PICKUP 
					local ba = BufferedAction(owner1, inst, action)
					owner1.components.locomotor:PushAction(ba, true)
				end

				
				inst:DoTaskInTime(0.5, function() 
					if inst.components.inventoryitem and inst.components.inventoryitem.owner and inst.components.inventoryitem.owner==nil then
						inst:Remove()
					elseif not owner1 then
						inst:Remove()
					end
				end)
		end
		inst:DoPeriodicTask(10, function()
			inst.components.inventoryitem:ChangeImageName("balloons_empty")	
			if inst.components.inventoryitem and inst.components.inventoryitem.owner and inst.components.inventoryitem.owner==GetPlayer() then
				inst:Remove()
			end
		end)
		inst:AddTag("specialitemplayer3")
		inst:ListenForEvent("ondropped", undropppable) 
		inst.components.inventoryitem:ChangeImageName("balloons_empty")	
	
	
	
	
    return inst
end

return Prefab( "common/balloons_empty_player_3", fn, assets, prefabs) 
